### 1. **Introduction to SNMP**

- **Purpose:** SNMP (Simple Network Management Protocol) helps manage large, diverse networks by providing a standard method to monitor and control IP devices.
- **Evolution:** Three versions exist:
    - **SNMPv1 & SNMPv2:** Use community strings for protection.
    - **SNMPv3:** Adds authentication, integrity, and confidentiality.

---

### 2. **SNMP Operation and Architecture**

#### **Components**

- **SNMP Manager**
    
    - Runs on the Network Management System (NMS).
    - Polls agents, collects data, and sends instructions.
    - Can be part of platforms like Cisco Prime Infrastructure.
- **SNMP Agent**
    
    - Software process on managed devices.
    - Responds to SNMP queries and shares device statistics.
- **MIB (Management Information Base)**
    
    - Virtual storage of managed objects.
    - Structured as a tree; objects identified by OIDs.

#### **How SNMP Works**

- **Polling:** NMS periodically queries SNMP agents to collect performance data.
- **Historical Data:** Allows trend analysis and triggers alarms based on thresholds.

#### **Notifications**

- **Traps:** Unsolicited alerts from devices to NMS.
- **Informs:** Like traps but require acknowledgment from the NMS.

---

### 3. **SNMP Protocol Details**

- **Layer:** Application layer protocol.
- **Transport:** Uses UDP.
- **SNMPv3 Security:** Authenticates and encrypts management data.

#### **SNMPv3 Structure**

- **Engine ID:** Unique identifier for each SNMP system.
- **Components:** Manager, Agent, MIB.

#### **Operations**

- **Get:** Retrieves values from managed devices.
- **Get-next:** Gets next object in the MIB.
- **Get-bulk:** Retrieves large sections of tables.
- **Set:** Modifies data on the managed device.
- **Trap/Inform:** Sends notifications from agent to manager.

---

### 4. **MIB Tree Structure & OIDs**

- **Hierarchical Structure:** Organized as a tree.
- **OIDs:** Numeric identifiers (e.g., 1.3.6.1.2.1.1.5 for system name).
- **Navigation:** Use SNMP object navigator or MIB Locator.

---

### 5. **SNMP Versions and Security**

#### **Security Comparison Table**

|Version|Access Mode|Authentication|Encryption|
|---|---|---|---|
|SNMPv1|noAuthNoPriv|Community string|No|
|SNMPv2|noAuthNoPriv|Community string|No|
|SNMPv3|noAuthNoPriv|Username|No|
|SNMPv3|authNoPriv|MD5 or SHA|No|
|SNMPv3|authPriv|MD5 or SHA|DES, 3DES, AES|

#### **SNMPv3 Security Levels**

- **noAuthNoPriv:** Username-based authentication, no encryption.
- **authNoPriv:** Hash-based authentication (MD5/SHA), no encryption.
- **authPriv:** Hash-based authentication (MD5/SHA) with data encryption (DES/AES).

> **Note:** MD5 and DES are outdated and should be replaced by SHA and AES for security.

---

### 6. **Access Control and Views**

- **View-Based Access Control Model:**
    
    - SNMPv3 uses groups and views for access control.
    - **Groups:** Define user privileges and access modes (read, write, notify).
    - **Views:** Define which MIB objects are accessible.
    - **Assignment:** Users are assigned to groups, inheriting group privileges.
- **SNMPv1/v2:** Community strings can be restricted to certain views.
    
- **SNMPv3:** Uses user-based access and group policies for finer control.
    

---

### 7. **Best Practices and Use Case: SNMPv3 on Cisco Devices**

#### **Recommended Configuration Steps**

1. **Define Engine ID:** Unique per device.
2. **Configure SNMP Views:** Limit NMS access to specific MIB sections.
3. **Create SNMP Groups:** Specify security policies and views.
4. **Add SNMP Users:** Assign to groups; specify authentication/encryption.
5. **Configure Traps/Informs:** Define NMS host and notification security.
6. **Apply ACLs:** Restrict SNMP access by IP address.

#### **Cisco SNMPv3 Configuration Example**

- Set engine ID:
    - `snmp-server engineID local 010010010099`
- Define view:
    - `snmp-server view MY-SNMP-VIEW interfaces included`
- Create group:
    - `snmp-server group MY-SNMP-GROUP v3 priv read MY-SNMP-VIEW access 99`
- Add user:
    - `snmp-server user MY-SNMP-USER MY-SNMP-GROUP v3 auth sha <auth_password> priv aes 128 <priv_password>`
- Configure informs:
    - `snmp-server host 10.10.10.50 informs version 3 priv MY-SNMP-USER`
- Enable traps:
    - `snmp-server enable traps`
- Set ACL:
    - `access-list 99 permit 10.10.10.0 0.0.0.255`

#### **Use Case Example**

- SNMP user with read-only access to interface parameters.
- Access limited to 10.10.10.0/24 network.
- Uses SHA-1 for authentication and AES-128 for encryption.

---

### 8. **Additional Notes**

- **Device Support:** Most Cisco platforms (routers, switches, firewalls, email/web appliances) support SNMP.
- **Security:** Always use latest and strongest authentication/encryption algorithms.
- **Verification:** Use SNMP browsers or management tools to confirm configuration.